{ pkgs ? import <nixpkgs> {} }:

pkgs.mkShell {
  buildInputs = with pkgs; [
    minikube
    kubernetes-helm
    bash-completion
    jq
    docker
    just
  ];

  shellHook = ''
    echo "Development shell loaded."

    # Enable kubectl completion
    if command -v kubectl > /dev/null; then
      source <(kubectl completion bash)
    fi

    # Enable helm completion
    if command -v helm > /dev/null; then
      source <(helm completion bash)
    fi

    # Alias kubectl to minikube kubectl for convenience
    alias kubectl='minikube kubectl --'

    echo "Type 'kubectl' to use the Minikube-provided kubectl."
  '';
}

