{ pkgs ? import <nixpkgs> {} }:

pkgs.mkShell {
  buildInputs = with pkgs; [
    minikube
    kubernetes-helm
    bash-completion
    jq
    docker
    just
    sops           # SOPS for secrets encryption/decryption
    age            # age encryption backend for SOPS
    gnupg          # for PGP/GPG support, if needed
    kubectl        # included separately for completions (supports minikube override/alias)
    envsubst       # for templating manifests, useful in CI/CD flows
  ];

  shellHook = ''
    echo "Development shell loaded."

    # Enable kubectl completion
    if command -v kubectl > /dev/null; then
      source <(kubectl completion bash)
    fi

    # Enable helm completion
    if command -v helm > /dev/null; then
      source <(helm completion bash)
    fi

    # Alias kubectl to minikube kubectl for convenience
    alias kubectl='minikube kubectl --'

    echo "Type 'kubectl' to use the Minikube-provided kubectl."
  '';
}
