#!/bin/bash

# Check for available updates
echo "Checking for available updates..."
apt update -qq
UPGRADABLE=$(apt list --upgradable 2>/dev/null | grep -v "Listing..." | grep -v "^$")

if [ -z "$UPGRADABLE" ]; then
    echo "Proxmox VE is already up to date."
    exit 0
fi

echo "Updating Proxmox VE (please wait)..."
apt full-upgrade -y && apt autoremove -y && apt autoclean
echo "Proxmox VE update complete."

# Countdown before reboot
COUNTDOWN=30
echo "System will reboot in $COUNTDOWN seconds. Press Ctrl+C to cancel."
while [ $COUNTDOWN -gt 0 ]; do
    echo -ne "Rebooting in $COUNTDOWN seconds...\r"
    sleep 1
    COUNTDOWN=$((COUNTDOWN-1))
done

echo -e "\nRebooting now."
reboot
